; ****************************************************
; Magneto for unrealIRCd v 1.52 (2007) by Averell
; Please type /load -rs magneto/magnetunreal.mrc
; Read the readme.txt in magneto folder
; ****************************************************

on 1:load: set %linkpass openaccess | set %linkport 4400 | set %linkserv localhost | set %linkwho $false
on 1:unload: unset %linkpass | unset %linkserv | unset %linkport | unset %tempport | unset %tempserv | unset %temppass | unset %tapageur | unset %tempwho | unset %linkwho

on 1:start: echo 12 -a Magneto for UnrealIRCD v1.52 (c) Averell 2004-2007

; on 1:sockread:lktelnet*: sockread %temp | echo 4 -a *** %temp

dialog dlink {
  title "Magneto for Unreal's configuration box"
  size -1 -1 400 182

  box "", 11, 10 10 380 150
  button "&Accept", 101, 260 62 120 25, default
  button "&Cancel", 111, 260 94 120 25,cancel
  text "Server's ip address", 103, 0 30 110 25,right
  text "Linking port", 104, 0 62 80 25,right
  text "Linking pass", 107, 0 94 80 25,right
  text "/WHO on join", 109, 0 126 80 25,right

  edit "",105,115 30 100 25,right
  edit "",106,115 62 100 25,right
  edit "",108,115 94 100 25,right
  check "(Yes/No)",110,115 126 100 25,right
}

on 1:dialog:dlink:edit:105:{ %tempserv = $did(105).text }
on 1:dialog:dlink:edit:106:{ %tempport = $did(106).text }
on 1:dialog:dlink:edit:108:{ %temppass = $did(108).text }
on 1:dialog:dlink:sclick:110:{ %tempwho = $iif($did(110).state == 1,$true,$false) }
on 1:dialog:dlink:sclick:101: dialog -c dlink | set %linkport %tempport | set %linkpass %temppass | set %linkserv %tempserv | set %linkwho %tempwho

alias magconfig   {
  dialog -m dlink dlink
  did -ra dlink 105 %linkserv
  did -ra dlink 106 %linkport
  did -ra dlink 108 %linkpass
  did $iif(%linkwho,-c,-u) dlink 110
  set %tempport %linkport | set %temppass %linkpass | set %tempserv %linkserv | set %tempwho %linkwho
}

alias initlink { 
  if ( %linked == $true ) termine
initlnk %linkserv %linkport }

alias initlnk {
  if ( $2 == $null ) return
  .enable #ouvretel

  if ($3 == $null) { set %fichier $$file="Name of sequence file" magneto\mylogs\ }
  else { set %fichier $3 }
  set %i 1
  :boucle
  set %j 1
  :boucle2
  %temp = lktelnet $+ %j
  if ( $sock(%temp).name == $null ) { sockopen %temp $1 $2 | goto suite2 }
  inc %j
  goto boucle2
  :suite2
  window -hekl20 @ $+ %temp  ms sans serif 14 | titlebar @ $+ %temp sur $1 ( $+ $2 $+ )
  aline -ph 4 @ $+ %temp Client lktelnet - par Averell
}

#ouvretel off
on 1:sockopen:lktelnet*: {
  ;  %temp2 = $right($sockname,$calc($len($sockname)-6))
  if ( $sockerr > 0 ) { aline -ph 2 @ $+ $sockname Pas de connexion trouve | echo 12 -a * Error! UnRealIRCD not found, or bad port number... | return }
  else  { aline -ph 4 @ $+ $sockname Connexion tablie | set %linked $true | .enable #offline | nick $myaleanick | lislog }
  aline -ph 1 @ $+ $sockname pass : $+ %linkpass
  aline -ph 1 @ $+ $sockname server irc.magneto.org 1 :Magneto for Unreal
  sockwrite -n $sockname pass : $+ %linkpass
  sockwrite -n $sockname server irc.magneto.org 1 :Magneto for Unreal
  .timerping 0 60 /pingtel
}

alias pingtel sockwrite -n lktelnet1 PING :12345

on 1:sockclose:lktelnet*: unset %linked | echo 12 -a * Error! The linking password does not suit! Please update it... | .disable #ouvretel | .timerping off
#ouvretel end

on 1:close:@lktelnet*: %temp = $gettok($target,1,58) | %temp = $right(%temp,$calc($len(%temp)-1)) | sockclose %temp | unset %linked | .disable #ouvretel

alias initlog {
  ;
  set %fichier $$file="Name of the sequence file to create?" magneto\mylogs\
  write -c %fichier | window -h @Log | titlebar @log de $1 | clear @log
  set %timer 0 | timerlog -mo 0 100 /inc %timer
  %logchan = $1
  write %fichier 0 talk %logchan $ctime $me on $date at $time
  .enable #log | echo 3 $1 * Recording of the sequence started...
  ; dup
  who $me
  %i = 1
  while ( %i <= $chan(0) ) {
    ;   st : $+ $me JOIN $chan(%i)
    topic $chan(%i) | mode $chan(%i)
    inc %i
  }
  set %enre $true
}

alias mytime inc %curtime $1 | return $time($int($calc(%mytime + %curtime / 10)))

#log off

alias st {
  aline -ph 1 @log %timer $1- | write -a %fichier %timer $1- | set %timer 0
}

raw 352:*:{ 
  if ( $level($6) < 2 ) st NICK $6 1 2 $3 $4 irc.magneto.org : $+ $9- 
  if ( $6 == X || $6 == chanserv || $6 == irix ) { st : $+ $6 MODE $6 +q }
  if ( $chr(42) isin $7 ) { st : $+ $6 MODE $6 +o }
  .auser =2 $6
  set %i 1 | set %N $comchan($6,0)
  :boucle
  set %chan $comchan($6,%i)
  st : $+ $6 JOIN %chan
  set %peuple % $+ peuple $+ %chan
  set %peuple [ [ %peuple ] ]
  if ( $6 ison %chan && %peuple == $null ) { st :irc.magneto.org MODE %chan -o $6 }
  if ( $6 isop %chan ) { st :irc.magneto.org MODE %chan +o $6 }
  elseif ( $6 ishop %chan ) { st :irc.magneto.org MODE %chan +h $6 }
  elseif ( $6 isvo %chan ) { st :irc.magneto.org MODE %chan +v $6 }
  set % $+ peuple $+ %chan $true
  inc %i
  if ( %i > %N ) return
  goto boucle
}

alias rotutu  if ( $comchan($1,0) == 0 ) { st : $+ $1 QUIT :Leaving | .ruser 2 $1 }
alias rutoto {
  if ( $level($1) < 2 ) { 
    set %user $gettok($2,1,64) | set %host $gettok($2,2,64)
    st NICK $1 1 2 %user %host irc.magneto.org :Magneto user
    .auser =2 $1
  }
  st : $+ $1 $3 $me : $+ $4-
}

alias myst {
  if ( $level($1) < 2 ) { 
    set %user $gettok($2,1,64) | set %host $gettok($2,2,64)
    st NICK $1 1 2 %user %host irc.magneto.org :Magneto user
    ;    .auser =2 $1
    if ( $1 == X || $1 == chanserv || $1 == irix ) { st : $+ $1 MODE $1 +q }
    st : $+ $1 JOIN $4
    set %peuple % $+ peuple $+ $4
    set %peuple [ [ %peuple ] ]
    if ($1 isvo $4) { st :irc.magneto.org MODE $4 +v $1 }
    elseif ($1 ishop $4) { st :irc.magneto.org MODE $4 +h $1 }
    elseif ($1 isop $4) { st :irc.magneto.org MODE $4 +o $1 }
    elseif (%peuple == $null) { st :irc.magneto.org MODE $4 -o $1 }
  }
  if ($3 != JOIN || $level($1) > 1) {  st : $+ $1 $3 $4 $5- }
  .auser =2 $1
  if ($3 == JOIN && $1 == $me) { st :irc.magneto.org MODE $4 -o $1 }
  set % $+ peuple $+ $1 $true
}

on 1:text:*:#: myst $nick $address PRIVMSG $chan : $+ $1-
on 1:action:*:#:myst $nick $address PRIVMSG $chan : $+ $chr(1) $+ ACTION $1- $chr(1)
on +2:text:*:#: st : $+ $nick PRIVMSG $chan : $+ $1-
on 1:join:#: { 
  if ( $nick == $me ) { topic $chan | mode $chan }
  elseif (%linkwho == $false) { myst $nick $address JOIN $chan }
else who $nick }
on +2:join:#: { if (%linkwho == $false) { myst $nick $address JOIN $chan }
  else who $nick
}
on 2:part:#:st : $+ $nick PART $chan | .timer 1 1 rotutu $nick 
on 2:quit:st  : $+ $nick QUIT : $+ $1- | .ruser 2 $nick
on 2:op:#:myst $nick $address MODE $chan +o $opnick
on 2:serverop:#:st  : $+ $nick MODE $chan +o $opnick
on 2:deop:#:myst $nick $address MODE $chan -o $opnick
on 2:voice:#:myst $nick $address MODE $chan +v $vnick
on 2:devoice:#:myst $nick $address MODE $chan -v $vnick
on 2:help:#:myst $nick $address MODE $chan +h $hnick
on 2:dehelp:#:myst $nick $address MODE $chan -h $hnick
on 2:nick: st  : $+ $nick NICK : $+ $newnick | .ruser 2 $nick | .auser =2 $newnick
on 1:ban:#: myst $nick $address MODE $chan +b $banmask
on 1:unban:#: st  : $+ $nick MODE $chan -b $banmask
raw 332:*: st :irc.magneto.org TOPIC $2 : $+ $3-
on 2:kick:#: myst $nick $address KICK $chan $knick : $+ $1- 
; | .timer 1 1 rotutu $knick
on 2:notice:*:#:myst $nick $address NOTICE $chan : $+ $1-
ctcp 2:*:#: st  : $+ $nick PRIVMSG $chan : $+ $chr(1) $+ $1- $chr(1)
alias dup who $active | topic $active | mode $active
raw 324:*:st  :irc.magneto.org MODE $2 $3-
on +2:action:*:#:st $nick $address PRIVMSG $chan : $+ $chr(1) $+ ACTION $1- $chr(1)
on 2:topic:#:myst $nick $address TOPIC $chan : $+ $1-
on 2:mode:#:myst $nick $address MODE $chan $1-
on *:notice:*:?: rutoto $nick $address NOTICE $1-
on *:text:*:?: rutoto $nick $address PRIVMSG $1-
on *:action:*:?: rutoto $nick $address PRIVMSG $chr(1) $+ ACTION $1- $chr(1)

on *:input:#: {  if ($left($1,1) != / ) { st : $+ $me PRIVMSG $active : $+ $1- }
  else if ($left($1,3) == /me ) { st : $+ $me PRIVMSG $active : $+ $chr(1) $+ ACTION $2- $chr(1) }
}

on *:input:?: {  if ($left($1,1) != / ) { st : $+ $me PRIVMSG $active : $+ $1- }
  else if ($left($1,3) == /me ) { st : $+ $me PRIVMSG $active : $+ $chr(1) $+ ACTION $2- $chr(1) }
}

#log end

alias arrete {
  if ( %linked != $true ) { stoplog | echo 3 -a * Recording stopped | unset %enre | unset %peuple* } 
  else { termine }
}

menu menubar {
  $iif(%enre != $true,Magneto for Unreal)
  . $iif(%linked != $true,Record a sequence): initlog
  . $iif(%linked == $true,View)
  ..$iif(%pause == $null,Pause): stoplog | set %pause 1 | echo 3 -a * Pause...
  ..$iif(%pause != $null,Continue after pause): echo 3 -a * Continue... | unset %pause | visionne
  ..$iif(%accelere == $null,Accelerate): set %accelere $true
  ..$iif(%accelere == $true,Regular speed): unset %accelere
  ..Step by step:step
  ..End the session: termine
  . $iif(%linked != $true,Read a sequence): initlink
  . $iif(%linked == $true,End of session): arrete
  .-
  .$iif(%linked != $true,Configure): magconfig
  $iif(%enre == $true,Magneto for Unreal)
  .Stop recording: arrete
}

menu channel {
  $iif(%linked == $true,Magneto for Unreal)
  .$iif(%pause == $null,Pause): stoplog | set %pause 1 | echo 3 -a * Pause...
  .$iif(%pause != $null,Continue after pause): echo 3 -a * Continue... | unset %pause | visionne
  .$iif(%accelere == $null,Accelerate): set %accelere $true
  .$iif(%accelere != $null,Regular speed): unset %accelere
  .Step by step:step
  .Reset #:rstchan #
  .End of session: termine
  $iif(%linked != $true,Magneto for Unreal)
  . $iif(%enre != $true,Record a sequence): initlog
  . $iif(%enre == $true,Stop recording): arrete
}

alias stoplog .timerlog off | .disable #log | unset %accelere | .rlevel -r 2

#offline off

alias addni  set %temp1 $right($1,$calc($len($1)-1)) | aline -l @lktelnet1 %temp1

alias remni {
  set %temp1 $right($1,$calc($len($1)-1))
  %i = 1
  :next
  if ( %i > $line(@lktelnet1,0,1)) goto fin2
  %temp = $line(@lktelnet1,%i,1))
  if ( %temp1 == %temp )  goto fin
  inc %i
  goto next
  :fin
  dline -l @lktelnet1 %i
  :fin2
}

alias mjj {
  set %i 1
  while ( %i <= $line(@lktelnet1,0,1) ) {
    sockwrite -n lktelnet1 : $+ $line(@lktelnet1,%i,1) JOIN $active
    inc %i
  }
}

alias d /sockwrite -n lktelnet1 : $+ $1 PRIVMSG $active : $+ $2- | if ( $asc($active) != 35 ) echo 2 -a < $+ $1 $+ > $2-
alias m /sockwrite -n lktelnet1 : $+ $1 MODE $active $3 $2 
alias no  /sockwrite -n lktelnet1 : $+ $1 NOTICE $active : $+ $2- |  if ( $asc($active) != 35 ) echo 2 -a - $+ $1 $+ - $2- 
alias jj  /sockwrite -n lktelnet1 : $+ $1 JOIN : $+ $active
alias pp  /sockwrite -n lktelnet1 : $+ $1 PART $active $iif($1 != $null,: $+ $2-)
alias mm  /sockwrite -n lktelnet1 : $+ $1 PRIVMSG $active :ACTION $2-  | if ( $asc($active) != 35 ) echo 2 -a $1 $2-  
alias qq  /sockwrite -n lktelnet1 : $+ $1 QUIT : $+ $iif($1 == $null,Leaving,$2-)
alias kk /sockwrite -n lktelnet1 : $+ $1 KICK $active $2 : $+ $3-

alias tertous {
  %i = 1
  :next
  if ( %i > $line(@lktelnet1,0,1)) goto fin
  %temp = $line(@lktelnet1,%i,1))
  sockwrite -n lktelnet1 : $+ %temp PRIVMSG $active : $+ $1- | if ( $asc($active) != 35 ) echo 2 -a < $+ $1 $+ > $2-
  inc %i
  goto next
  :fin
}

alias envoie { 
  if (%linked != $true) return
  ;  if (%curline == 1 ) { unset %titlebar | unset %fmodes | unset %ftopic | return }
  ; echo 4 -a $1-
  if ( $2 == nick ) { addni : $+ $3 }
  else if ( $3 == quit ) { remni $2 }
  else if ( $3 == nick ) { remni $2 | addni $4 }
  else if ( $2 == talk ) { %me = $4
    sockwrite -n lktelnet1 NICK Information 1 2 Global service.magneto.org irc.magneto.org : $+ $4 $+  $5-
    sockwrite -n lktelnet1 :Information NOTICE $me :Magneto-Log performed by  $+ $4 $+  $5-
  }

  if ( $2 == : $+ %me && $3 == nick ) { set %temp %me | set %me $right($4,$calc($len($4)-1))
    sockwrite -n lktelnet1 :Information NOTICE $me :Caution!  $+ %temp $+  has become  $+ %me $+ 
  }
  if ( $2 == : $+ %me && $3 == privmsg && $asc($4) != 35 ) { echo 2 $4 $chr(91) $+ $time $+ $chr(93) < $+ $right($2,$calc($len($2)-1)) $+ > $right($5-,$calc($len($5-)-1)) }
  else if ( ( $3 == notice || $3 == privmsg ) && $4 == %me ) { sockwrite -n lktelnet1 $2 $3 $me $5- }
  else  sockwrite -n lktelnet1 $2- 
  if ( $2 == : $+ %me && $3 == join ) { raw join $4 | sockwrite -n lktelnet1 :irc.magneto.org MODE $4 -o $me }
}

alias step {
  if (%curline == 1) set %curtime 0
  if ( %curline > $calc(%maxlines + 0) ) { echo 3 -a * End of session | timerlog off | return }
  ;  
  %oldline = %line
  ; si 1re ligne, %oldline est indfini mais envoie ne fait rien au premier step
  %line = $read -nl $+ %curline %fichier
  envoie %oldline
  inc %curline
}

alias termine sockclose lktelnet1 | .rlevel -r 2 | unset %linked | stoplog | set %curline 1 | .disable #offline | window -c @lktelnet1 | .disable #ouvretel | .timerping off
#offline end

alias lislog {
  %maxlines = $lines(%fichier) | set %curline 1 | stoplog
  visionne
}

alias visionne { 
  ;  echo 1 -s putain %line
  if (%curline == 1) set %curtime 0
  if ( %linked != $true ) { return }
  if ( %curline > $calc(%maxlines + 1) ) { echo 3 -a * End of session | timerlog off | return }
  ; | ame annonce la fin du film 
  %oldline = %line
  ; si 1re ligne, %oldline est indfini mais envoie ne fait rien au premier step
  %line = $read -nl $+ %curline %fichier
  %c = $asc($gettok(%line,1,32))
  if ( %curline == 1) { if ( %c < 48 || %c > 57 || %c == $null )  { echo 12 -a * Error! This is not a valid sequence file... | stoplog | return } }
  envoie %oldline
  inc %curline
  %deltat = $iif(%accelere == $null,100,1)
  .timerlog -om 1 $calc(%deltat * ($gettok(%line,1,32))) /visionne
}

alias myaleanick {
  %i = 0 | unset %temp
  :putain
  %temp = %temp $+ $rand(a,z)
  inc %i
  if ( %i < 9 ) goto putain
  return %temp
}

alias rstchan {
  ; on doit donner le nom du chan...
  var %myline,%i

  set %i 1

  window -hSkl12 @channel

  while (%i <= %curline) {
    %myline = $read -nl $+ %i %fichier
    if ($gettok(%myline,4,32) == $1 || $gettok(%myline,3,32) == quit || $gettok(%myline,3,32) == nick) {
      aline -ph 1 @channel %myline
      mag2.traite %myline
    }
    inc %i
  }

  set %i 1
  while (%i <= $line(@channel,0,1)) {
    %temp = $line(@channel,%i,1)
    %nick = %temp | if ($left(%nick,1) isin +@%&~) { %nick = $right(%nick,$calc($len(%nick)-1)) }
    if (%nick !ison $1) { sockwrite -n lktelnet1 : $+ %nick JOIN $1 }
    if ($left(%temp,1) == +) %signe = v
    elseif ($left(%temp,1) == @ || $left(%temp,1) == & || $left(%temp,1) == ~) { %signe = o }
    elseif ($left(%temp,1) == %) %signe = h
    else unset %signe
    if (%nick isvo $1) { %signe2 = v }
    elseif (%nick ishop $1) { %signe2 = h }
    elseif (%nick isop $1) { %signe2 = o }
    else unset %signe2

    if (%signe != %signe2) { 
      if (%signe2 != $null) %signe2 = - $+ %signe2 
      if (%signe != $null) %signe = + $+ %signe
      sockwrite -n lktelnet1 :irc.magneto.org MODE $1 %signe2 $+ %signe %nick %nick
    }
    inc %i
  }
  window -c @channel
}

alias mag2.userho %nick = $right($1,$calc($len($1)-1))

alias mag2.signe {
  %i = 1 | unset %signe | %trouve = $false
  :next
  if ( %i > $line(@channel,0,1)) goto fin2
  %temp = $line(@channel,%i,1)) | mag2.remsigne %temp
  if ( $1 == %nick1 )  goto fin
  inc %i
  goto next
  :fin
  %signe = %signe1
  %trouve = $true
  :fin2
}

alias mag2.remsigne {
  %c = $left($1,1)
  if (%c !isin @+%&~) { set %nick1 $1 | unset %signe1 | return }
  set %signe1 %c | %nick1 = $right($1,$calc($len($1) - 1))
}

alias mag2.addni aline -l @channel $1

alias mag2.remni mag2.remnick $1 | mag2.remnick @ $+ $1 | mag2.remnick + $+ $1

alias mag2.remnick {
  %i = 1
  :next
  if ( %i > $line(@channel,0,1)) goto fin2
  %temp = $line(@channel,%i,1))
  if ( $1 == %temp )  goto fin
  inc %i
  goto next
  :fin
  dline -l @channel %i
  :fin2
}

alias mag2.traite {
  ; nombre, :blabla , instruction, canal, reste de l'instruction

  %nick = $right($2,$calc($len($2)-1))

  if ($3 == join) { mag2.signe %nick | if (%trouve == $true) return
  mag2.addni %nick }
  elseif ($3 == part || $3 == quit) { mag2.remni %nick }
  elseif ($3 == topic) %ftopic = $5-
  elseif ($3 == nick) { mag2.signe %nick | if (%trouve == $false) return
  mag2.remni %nick | mag2.addni %signe $+ $right($4,$calc($len($4)-1)) }
  elseif ($3 == mode) {
    if ($5 == +o )  { mag2.remni $6 | mag2.addni @ $+ $6 }
    elseif ($5 == -o )  { mag2.remni $6 | mag2.addni $6 }
    elseif ($5 == +h )  { mag2.signe $6 | if (%signe != @ ) { mag2.remni $6 | mag2.addni % $+ $6 }
    }
    else if ($5 == -h )  { mag2.signe $6 | if (%signe != @ ) { mag2.remni $6 | mag2.addni $6 }
    }
    elseif ($5 == +v )  { mag2.signe $6 | if (%signe != @ ) { mag2.remni $6 | mag2.addni + $+ $6 }
    }
    else if ($5 == -v )  { mag2.signe $6 | if (%signe != @ ) { mag2.remni $6 | mag2.addni $6 }
    }
  }
  elseif ($3 == kick) mag2.remni $5
}
